// utils/email.js
const { Resend } = require("resend");

// Initialize Resend
const resend = new Resend(process.env.RESEND_API_KEY);

const sendEmail = async (options) => {
  const mailOptions = {
    from: process.env.EMAIL_FROM,
    to: options.email,
    subject: options.subject,
    html: options.html,
  };

  // 🚀 ATTACHMENTS REMOVED
  // We strictly avoid sending physical files for logos.
  // Images should be hosted URLs in the HTML <img> tag.

  try {
    const data = await resend.emails.send(mailOptions);
    console.log(`✅ Email sent successfully to ${options.email}`, data);
  } catch (error) {
    console.error("🔥 Error sending email:", error);
    throw new Error("Email sending failed");
  }
};

module.exports = sendEmail;
